#! /bin/sh
set -e

nt=$(uname -s | sed -ne 's/CYGWIN_NT-\(.*\)/\1/p')

cd /etc
if [ -n "$nt" ]
then
  export CYGWIN=ntsec
  SYSTEMUID=$(sed -ne '/^[^:]*:[^:]*:[0-9]*:[0-9]*:[^:]*,S-1-5-18:.*:/{s/[^:]*:[^:]*:\([0-9]*\):.*$/\1/p;q}' /etc/passwd)
  ADMINSGID=$(sed -ne '/^[^:]*:S-1-5-32-544:.*:/{s/[^:]*:[^:]*:\([0-9]*\):.*$/\1/p;q}' /etc/group)
  setfacl -m u::rw-,g::rw-,o:r-- defaults/etc/exim.conf
  if [ -n "${SYSTEMUID}" -a -n "${ADMINSGID}" ]
    then
    chown "${SYSTEMUID}:${ADMINSGID}" defaults/etc/exim.conf
  fi
fi
if [ ! -e exim.conf ]
  then
  cp --remove-destination defaults/etc/exim.conf exim.conf
  if [ -n "$nt" ]
  then
    chmod 777 /var/spool/exim /var/log/exim
    chmod 664 exim.conf
    if [ -n "${SYSTEMUID}" -a -n "${ADMINSGID}" ]
      then
      chown "${SYSTEMUID}:${ADMINSGID}" /var/spool/exim /var/log/exim exim.conf
    fi
  fi
fi
