/* $Id: version.c,v 1.6 2002/11/12 19:14:07 cwilson Exp $ */

/*
 *   IPC package for CygWin
 *
 *   Copyright (C) 1997 Philippe CHAPUY
 *   Copyright (C) 1998 Ludovic LANGE
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */

/*
 *   HISTORY:
 *   --------
 *
 *   13/05/1998 : Version 1.00 released
 *                First public release
 *                adress any comments to llange@capgemini.fr
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <syslog.h>
#include <sys/ipctrace.h>
#include <ctype.h>
extern err_handlerP err_handler;

void	FVersionInfo(char argc,char **argv)
{
    unsigned short Li;
    unsigned short Lversioninfo=0;
    unsigned short LVersionMajor=1;
    unsigned short LVersionMinor=0;
    char	LBuf[512];
    if (argc<2)
    {
      return;
    }
    for (Li=1;Li<argc;Li++)
    {
      if ( (strcmp(argv[Li],"--version")==0) || (strcmp(argv[Li],"-V")==0) )
      {
        Lversioninfo=1;
      }
    }
    if (Lversioninfo==0)
    {
      return;
    }
    LVersionMajor=(unsigned short) floor(VERSION_NUM);
    LVersionMinor=(unsigned short) rint( (100.0 * VERSION_NUM) - (100.0*((double)LVersionMajor)) );

    sprintf(LBuf,"%s : CygWin IPC Package Version %d.%02d (c) 1998 PCH/LLA\n",argv[0],LVersionMajor,LVersionMinor);
    err_handler(stderr, LOG_INFO, LBuf);
    exit(0);
}

